<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Adv_Hoarding_m;
use Illuminate\Support\Facades\Validator;
use PDF;
use QrCode;
use App\Ward;
use DB;
// use Imagick;
use Illuminate\Support\Facades\Crypt;
use Auth;
class Adv_Hoarding extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index()
    {
       $adv=Adv_Hoarding_m::all();
       return view('adv_hoarding/list',compact('adv'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data=$this->getloc();
	    if(empty($data))
	    {
	      	$latitude='';
 			$longitude='';  
	    }
	    else
	    {
	        $latitude=$data[0];
 			$longitude=$data[1]; 
	    }
       return view('adv_hoarding/create',compact('latitude','longitude'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       // return $request->all();
        $this->validate($request, [
           'licence_no' => 'required|unique:tbl_adv_hoarding,licence_no',
           'advertiser_name' => 'required',
           'adv_loc' => 'required',
           'adv_type' => 'required',
           'adv_size' => 'required',
           'total_area' => 'required',
           'renewal_period' => 'required',
           'latitude' => 'required',
           'longitude' => 'required',

            
        ],[
           'licence_no.required' => "परवाना क्रमांक /  License Number is required",
           'advertiser_name.required' => "जाहिरातदाराचे नाव व पत्ता / Advertiser's Name & Address is required",
           'adv_loc.required' => "जाहिरातीचे ठिकाण / Advertisement Location is required",
           'adv_type.required' => "जाहिरात प्रकार / Advertisement Type is required",
           'adv_size.required' => "जाहिरात साईज / Advertisement Size is required",
           'total_area.required' => "एकूण क्षेत्रफळ / Total Area is required",
           'renewal_period.required' => "नूतनीकरण कालावधी / Renewal Period is required",
           'latitude.required' => "अक्षांश / Latitude is required",
           'longitude.required' => "रेखांश / Longitude is required",
          ]);
          
        $adv = new Adv_Hoarding_m();
        $adv = $adv->Create($request->all());
        $no= $adv->licence_no;
        $id = base64_encode($no);
        $title = 'licence_no_';
        
        $pdf = PDF::loadView('qrCode', compact('id','no'));
        $path = public_path('qrpdf/');
        $fileName = $title.$no.'.pdf' ;
        $imgName = $title.$no.'.jpg' ;
        $pdf->save($path . '/' . $fileName);

        // $imagick = new Imagick();
        // $imagick->readImage(public_path('qrpdf/'.$fileName));
        // $saveImagePath = public_path($imgName);
        // $imagick->writeImages($saveImagePath, true);


        // $adv->qrcode=$imgName;
        $adv->save();
   
    
    return redirect()->route('adv_hoarding.index')->with('flash_message','Advertisement Hoarding Added Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
    $ad=Adv_Hoarding_m::find($id);
    if($ad->renewal_period!='NA')
    {
         $str=$ad->renewal_period;
         preg_match_all('/\d{2}\/\d{2}\/\d{4}/',$str,$matches);
         $fromdate=$matches[0][0];
         $todate=$matches[0][1];
         
    }
    else
    {
      $fromdate="NA";
      $todate="NA";  
    }
    $data=$this->getloc();
	    if(empty($data))
	    {
	      	$latitude='';
 			$longitude='';  
	    }
	    else
	    {
	        $latitude=$data[0];
 			$longitude=$data[1]; 
	    }
    return view('adv_hoarding/edit',compact('ad','fromdate','todate','latitude','longitude'));
    
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    //   $this->validate($request, [
       
    //       'advertiser_name' => 'required',
    //       'adv_loc' => 'required',
    //       'adv_type' => 'required',
    //       'adv_size' => 'required',
    //       'total_area' => 'required',
    //       'renewal_period' => 'required',
    //       'latitude' => 'required',
    //       'longitude' => 'required',

            
    //     ],[
          
    //       'advertiser_name.required' => "जाहिरातदाराचे नाव व पत्ता / Advertiser's Name & Address is required",
    //       'adv_loc.required' => "जाहिरातीचे ठिकाण / Advertisement Location is required",
    //       'adv_type.required' => "जाहिरात प्रकार / Advertisement Type is required",
    //       'adv_size.required' => "जाहिरात साईज / Advertisement Size is required",
    //       'total_area.required' => "एकूण क्षेत्रफळ / Total Area is required",
    //       'renewal_period.required' => "नूतनीकरण कालावधी / Renewal Period is required",
    //       'latitude.required' => "अक्षांश / Latitude is required",
    //       'longitude.required' => "रेखांश / Longitude is required",
    //       ]);
          $ad=Adv_Hoarding_m::find($id);
          $ad = $ad->update($request->all());
          return redirect()->route('adv_hoarding.index')->with('flash_message', 'Advertisement Hoarding Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
       $ads =Adv_Hoarding_m::find($id);
       $ads->Deleted_BY= Auth::id();
       $ads->save();
       $ad = Adv_Hoarding_m::find($id)->delete();
       
       return redirect()->route('adv_hoarding.index')->with('flash_message','Advertisement Hoarding Deleted Successfully');
    }
    
     function getloc()
    {
        $PublicIP = $this->get_client_ip();
        $json     = file_get_contents("http://ipinfo.io/$PublicIP/geo");
        $json     = json_decode($json, true);
        $country  = $json['country'];
        $region   = $json['region'];
        $city     = $json['loc'];
        $str_arr = explode (",", $city); 
        return $str_arr;

    }
    
    public function get_client_ip()
    {
        $ipaddress = '';
        if (isset($_SERVER['HTTP_CLIENT_IP'])) {
            $ipaddress = $_SERVER['HTTP_CLIENT_IP'];
        } else if (isset($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } else if (isset($_SERVER['HTTP_X_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_X_FORWARDED'];
        } else if (isset($_SERVER['HTTP_FORWARDED_FOR'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED_FOR'];
        } else if (isset($_SERVER['HTTP_FORWARDED'])) {
            $ipaddress = $_SERVER['HTTP_FORWARDED'];
        } else if (isset($_SERVER['REMOTE_ADDR'])) {
            $ipaddress = $_SERVER['REMOTE_ADDR'];
        } else {
            $ipaddress = 'UNKNOWN';
        }
    
        return $ipaddress;
    }
    
   
}
