<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Assign_Location;
use App\Tble_collection_login;
use DB;
use App\Ward;
use App\Collection_location;
class AssignLocationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
      public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {

    $assign_location_data=  DB::table('mst_assign_location')
            ->leftJoin('tble_collection_login', 'mst_assign_location.LoginId', '=', 'tble_collection_login.LoginId')
            ->leftJoin('mst_ward', 'mst_assign_location.ward', '=', 'mst_ward.id')
            ->select('mst_assign_location.id','tble_collection_login.Name', 'mst_assign_location.user_type', 'mst_ward.ward','mst_assign_location.type','mst_assign_location.total_emp')
            ->whereNull('mst_assign_location.deleted_at')
            ->orderBy('id','desc')
            ->get();
    return view("assign_location_master/assign_location_grid",compact('assign_location_data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $ward_data = Ward::orderBy('id','asc')->pluck('ward', 'id');
        $user_data = Tble_collection_login::orderBy('LoginId','desc')->pluck('Name', 'LoginId');
        return view("assign_location_master/assign_location",compact('ward_data','user_data'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
           'LoginId' => 'required',
           'user_type' => 'required',
           'ward' => 'required',
           'location' => 'required',
            
        ],[
           'LoginId.required' => 'User is required',
           'user_type.required' => 'User Type is required',
           'ward.required' => 'Ward  is required',
           'location' => 'required',
         ]);
         
        $assign_location = new Assign_Location();
        $assign_location = $assign_location->Create($request->except(['user_type_id']));
        return redirect()->route('assign_location.index')->with('flash_message', ' Assign Location Added Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $assign_location_data=Assign_Location::find($id);
        
        $ward =$assign_location_data->ward;
        $LoginId =$assign_location_data->LoginId;
        $location_data = Collection_location::where('Ward_Num', $ward)->pluck('Title', 'Uid');
        $userdata = Tble_collection_login::where('LoginId', $LoginId)->get(['Name','LoginId']);
        $ward_data = Ward::orderBy('id','asc')->pluck('ward', 'id');
        return view('assign_location_master/assign_location_edit',compact('assign_location_data','ward_data','location_data','userdata'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $this->validate($request, [
           'LoginId' => 'required',
           'user_type' => 'required',
           'ward' => 'required',
           'location' => 'required',
         ],[
           'LoginId.required' => 'User is required',
           'user_type.required' => 'User Type is required',
           'ward.required' => 'Ward  is required',
           'location' => 'required',
         ]);
         
        $assign_location=Assign_Location::find($id);
        $assign_location = $assign_location->update($request->except(['user_type_id']));
        return redirect()->route('assign_location.index')->with('flash_message', 'Assign Location Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $assign_location = Assign_Location::find($id)->delete();
        return redirect()->route('assign_location.index')->with('flash_message','Record Deleted Successfully');
    }
}
