<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Trans_Attendance;
use App\Ward;
use DB;
class AttendanceReportController extends Controller
{
       public function __construct()
    {
        $this->middleware('auth');
    }
    public function index(Request $req)
    {
     $ward_data = Ward::orderBy('id','asc')->pluck('ward', 'id');
     return view("attendance_report/attendance_report",compact('ward_data'));
    }

     public function displayReport(Request $req)
    {
      DB::enableQueryLog();
      $ward= $req->ward;
      $insertedDt= $req->insertedDt;

   
      if($ward=="all")
      {
        $attendance_report=DB::select("SELECT tbl_collection_location.Title,trans_attendance.totalPeople as Total_emp,mst_ward.ward,trans_attendance.eveningPresentCount,trans_attendance.eveningAbsentCount,trans_attendance.presentCount,trans_attendance.absentCount FROM `trans_attendance` LEFT JOIN mst_ward ON trans_attendance.ward=mst_ward.id LEFT JOIN tbl_collection_location ON tbl_collection_location.Uid=trans_attendance.UID  WHERE Date(trans_attendance.insertedDt)='$insertedDt' AND trans_attendance.deletedDt IS NULL");
        // $query = DB::getQueryLog();
        // print_r($query);
        // exit();
      }
  
	  else
	  {
	  	$attendance_report=DB::select("SELECT tbl_collection_location.Title,trans_attendance.totalPeople as Total_emp,mst_ward.ward,trans_attendance.eveningPresentCount,trans_attendance.eveningAbsentCount,trans_attendance.presentCount,trans_attendance.absentCount FROM `trans_attendance` LEFT JOIN mst_ward ON trans_attendance.ward=mst_ward.id  LEFT JOIN tbl_collection_location ON tbl_collection_location.Uid=trans_attendance.UID  WHERE trans_attendance.ward='$ward' AND Date(trans_attendance.insertedDt)='$insertedDt' AND trans_attendance.deletedDt IS NULL");
	  	// $query = DB::getQueryLog();
    //     print_r($query);
    //     exit();
	  }
    
        $reportData['data']=$attendance_report;
        echo json_encode($reportData);
        exit;
    }

    public function downloadAttendanceExcel(Request $req,$type)
    {
    DB::enableQueryLog();
    $hidden_ward= $req->hidden_ward;
    $hidden_insertedDt= $req->hidden_insertedDt;

    if($hidden_ward=="all")
      {
        $attendance_report=DB::select("SELECT tbl_collection_location.Title,trans_attendance.totalPeople as Total_emp,mst_ward.ward,trans_attendance.eveningPresentCount,trans_attendance.eveningAbsentCount,trans_attendance.presentCount,trans_attendance.absentCount FROM `trans_attendance` LEFT JOIN mst_ward ON trans_attendance.ward=mst_ward.id  LEFT JOIN tbl_collection_location ON tbl_collection_location.Uid=trans_attendance.UID  WHERE Date(trans_attendance.insertedDt)='$hidden_insertedDt' AND trans_attendance.deletedDt IS NULL");
      }
  
	  else
	  {
	  	$attendance_report=DB::select("SELECT tbl_collection_location.Title,trans_attendance.totalPeople as Total_emp,mst_ward.ward,trans_attendance.eveningPresentCount,trans_attendance.eveningAbsentCount,trans_attendance.presentCount,trans_attendance.absentCount FROM `trans_attendance` LEFT JOIN mst_ward ON trans_attendance.ward=mst_ward.id LEFT JOIN tbl_collection_location ON tbl_collection_location.Uid=trans_attendance.UID WHERE trans_attendance.ward='$hidden_ward' AND  Date(trans_attendance.insertedDt)='$hidden_insertedDt' AND trans_attendance.deletedDt IS NULL");
	  }
    
      $data = array();
      foreach ($attendance_report as $key=> $attendance) {
      $data[] = (array)$attendance;  
       #or first convert it and then change its properties using 
       #an array syntax, it's up to you
    }
     if(count($data) == 0) 
    {
      return redirect()->back()->with('dataError','Data not available');
    }

    foreach($data as $key=> $row) {
    $data_arr[] = array(
     'Sr. No.'=>$key+1,
     'Location' => $row['Title'],
     'Total Employee' => $row['Total_emp'],
     'Ward'=> $row['ward'],
     'Date'=>$hidden_insertedDt,
     'Morning Present ' => $row['presentCount'],
     'Morning Absent ' => $row['absentCount'],
     'Evening Present ' => $row['eveningPresentCount'],
     'Evening Absent ' => $row['eveningAbsentCount'],);
    }

     return \Excel::create('Attendance_report_'.$hidden_insertedDt, function($excel) use ($data_arr) {
            $excel->sheet('sheet name', function($sheet) use ($data_arr)
            {
                $sheet->setColumnFormat(array(
                  'C' => ' '
                ));
                $sheet->fromArray($data_arr,null,'A1',true);
                // $sheet->fromArray($data_arr, null, 'A1', true);
            });
        })->download($type);

    }

}
