<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Swachha_Bharat;
use App\visitor;
use DB;
use App\User;
use App\Feedback_Form;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $survey_datacount = Feedback_Form::count(); 
        $records = DB::table('survey_feedback')->select(DB::raw('*'))
                  ->whereRaw('MONTH(created_at) = MONTH(CURRENT_DATE())')->get();
        $surveycount=count($records);
        $category = Swachha_Bharat::pluck('category');
        $toiletcount=count($category);
        $wardwaisecnt=DB::select("SELECT mst_ward.ward ,count(survey_feedback.swachha_id) as cnt FROM `mst_ward` LEFT JOIN survey_feedback ON mst_ward.id=survey_feedback.ward AND MONTH(survey_feedback.created_at) = MONTH(CURRENT_DATE()) GROUP BY mst_ward.ward ORDER BY mst_ward.id asc"); 
        $ward=DB::select("SELECT * FROM `mst_ward`");
        // echo "<pre>";
        // print_r($wardwaisecnt) ;
        // exit();
        return view('home',compact('survey_datacount','surveycount','toiletcount','wardwaisecnt'));
    }

     public function googleLineChart()
    {
        // $data['lineChart'] = DB::table('visitor')
        //             ->select(
        //                 DB::raw("year(created_at) as year"),
        //                 DB::raw("SUM(click) as total_click"),
        //                 DB::raw("SUM(viewer) as total_viewer")) 
        //             ->orderBy("created_at")
        //             ->groupBy(DB::raw("year(created_at)"))
        //             ->get();

        // $data['lineChart'] = Swachha_Bharat::select(\DB::raw("COUNT(*) as count"), \DB::raw("SUM(category) as category"),\DB::raw('max(created_at) as createdAt'),\DB::raw('COUNT(*) as todaysurvey'))->whereRaw('Date(created_at) = CURDATE()')
        // ->get();
        $data['lineChart'] = User::select(\DB::raw("COUNT(*) as count"), \DB::raw("MONTHNAME(created_at) as month_name"),\DB::raw('max(created_at) as createdAt'))
        ->whereYear('created_at', date('Y'))
        ->groupBy('month_name')
        ->orderBy('createdAt')
        ->get();

        // $data['lineChart']=DB::select("SELECT COUNT(id) as total_survey, COUNT(category) as total_cat,(SELECT COUNT(id) FROM swachha_bharat_survey WHERE date(created_at)=CURDATE()) as todays FROM swachha_bharat_survey");

        return view('google-line-chart', $data);

        // $result[] = ['Year','Click','Viewer'];
        // foreach ($visitor as $key => $value) {
        //     $result[++$key] = [$value->year, (int)$value->total_click, (int)$value->total_viewer];
        // }


               return $data;

   
    }

    public function googleLineChart1()
    {
        $visitor = DB::table('visitor')
                    ->select(
                        DB::raw("year(created_at) as year"),
                        DB::raw("SUM(click) as total_click"),
                        DB::raw("SUM(viewer) as total_viewer")) 
                    ->orderBy("created_at")
                    ->groupBy(DB::raw("year(created_at)"))
                    ->get();


        $result[] = ['Year','Click','Viewer'];
        foreach ($visitor as $key => $value) {
            $result[++$key] = [$value->year, (int)$value->total_click, (int)$value->total_viewer];
        }


        return view('linechart')
                ->with('visitor',json_encode($result));
    }
}
