<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Tble_collection_login;
use Hash;
use App\Ward;
use App\Assign_Location;
use DB;
use App\Collection_location;

class LoginCollectionController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
      public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
       $tbl_collection_data=Tble_collection_login::all();
       return view("collection_login_master/grid",compact('tbl_collection_data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         return view("collection_login_master/register");
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
          $this->validate($request, [
           'Name' => 'required',
           'Mobile_no' => 'required|numeric|digits:10|unique:tble_collection_login,Mobile_no',
           'Password' => 'required|string|min:6',
           'User_Type' => 'required',
           'gender' => 'required',
            
        ],[
           'Name.required' => 'Name is required',
           'Mobile_no.required' => 'Mobile no. is required',
           'Password.required' => 'Password  is required',
           'User_Type.required' => 'User Type is required',
           'gender.required' => 'Gender is required',
         
          ]);
         // return $request->Mobile_no;
        $tble_collection_login = new Tble_collection_login();
        $tble_collection_login->Name = $request->Name;
        $tble_collection_login->Username = $request->Username;
        $tble_collection_login->Mobile_no = $request->Mobile_no;
        $tble_collection_login->Password = $request->Password;
        $tble_collection_login->User_Type = $request->User_Type;
        $tble_collection_login->gender = $request->gender;
        $tble_collection_login->Token = $request->_token;
        $tble_collection_login->save();
        return redirect()->route('tbl_collection.index')->with('flash_message', 'Record Added Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
      $tble_collection_login=Tble_collection_login::where('LoginId',$id)->first();
       return view('collection_login_master/edit',compact('tble_collection_login'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
         $this->validate($request, [
           'Name' => 'required',
           'Mobile_no' => 'required|numeric|digits:10',
           'Password' => 'required|string|min:6',
           'User_Type' => 'required',
           'gender' => 'required',
            
        ],[
           'Name.required' => 'Name is required',
           'Mobile_no.required' => 'Mobile no. is required',
           'Password.required' => 'Password  is required',
           'User_Type.required' => 'User Type is required',
           'gender.required' => 'Gender is required',
         
          ]);
        $tble_collection_login=Tble_collection_login::where('LoginId',$id)->first();
        $tble_collection_login->Name = $request->Name;
        $tble_collection_login->Mobile_no = $request->Mobile_no;
        $tble_collection_login->Username = $request->Username;
        $tble_collection_login->Password = $request->Password;
        $tble_collection_login->User_Type = $request->User_Type;
        $tble_collection_login->gender = $request->gender;
        $tble_collection_login->Token = $request->_token;
        $tble_collection_login->save();
        return redirect()->route('tbl_collection.index')->with('flash_message', 'Record Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $tbl_collection=Tble_collection_login::where('LoginId',$id)->first();
        $tbl_collection->delete();
        return redirect()->route('tbl_collection.index')->with('flash_message','Record Deleted Successfully');
    }

 
    public function fetch_user_type(Request $request)
    {
      
       //$tbl_collection=Tble_collection_login::where('LoginId',$LoginId)->first();
     $tbl_collection = Tble_collection_login::where('LoginId',$request->LoginId)->pluck('User_Type');
     return json_encode($tbl_collection);

    }
    
    public function fetch_location(Request $request,$ward_id)
    {
    return Collection_location::where('Ward_Num', $ward_id)->get(['Uid' ,'Title']);
    }
    
     public function fetch_data(Request $request,$location)
    {
     $area_data = Collection_location::where('Uid',$location)->get(['Lattitude','Longitude']);
     return json_encode($area_data);

    }
}
