<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Swachha_Bharat;
use Illuminate\Support\Facades\Validator;
use PDF;
use QrCode;
use App\Ward;
use DB;
use Imagick;

class SwachhaBharatController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        //$survey_data=Swachha_Bharat::all();
        $survey_data=  DB::table('swachha_bharat_survey')
            ->leftJoin('mst_ward', 'swachha_bharat_survey.ward', '=', 'mst_ward.id')
            ->select('swachha_bharat_survey.id', 'swachha_bharat_survey.swachha_id', 'swachha_bharat_survey.category','swachha_bharat_survey.Type','mst_ward.ward','swachha_bharat_survey.title','swachha_bharat_survey.address','swachha_bharat_survey.qrcode')
            ->whereNull('swachha_bharat_survey.deleted_at')
            ->orderBy('id','desc')
            ->get();
        return view('admin_master/survey_grid',compact('survey_data'));
    }

    
    public function create()
    {
        $ward_data = Ward::orderBy('id','asc')->pluck('ward', 'id');
        return view('admin_master/add',compact('ward_data'));
    }

    public function store(Request $request)
    {
        $this->validate($request, [
           'category' => 'required',
           'Type' => 'required',
           'swachha_id' => 'required|unique:swachha_bharat_survey,swachha_id',
           'ward' => 'required',
           'title' => 'required',
           'address' => 'required',

            
        ],[
           'category.required' => 'Category is required',
           'Type.required' => 'Type is required',
           'swachha_id.required' => 'Swachh Id is required',
           'ward.required' => 'Ward is required',
           'title.required' => 'Title is required',
           'address.required' => 'Address is required',
          ]);
   
        $swachha_bharat = new Swachha_Bharat();
        $swachha_bharat = $swachha_bharat->Create($request->all());
        $id= $swachha_bharat->id;
        $swachha_id = $swachha_bharat->swachha_id;
        $title = $swachha_bharat->title;
        $pdf = PDF::loadView('qrCode', compact('swachha_id','id','title'));
        $path = public_path('qrpdf/');
        $fileName = 'Swachch Bharat'.$swachha_id.'.pdf' ;
        $imgName = $title.$swachha_id.'.jpg' ;
        $pdf->save($path . '/' . $fileName);
        // return $pdf->stream('Swachch Bharat'.$swachha_id.'.pdf')
        //       ->header('Content-Type','application/pdf');


        $imagick = new Imagick();
        $imagick->readImage(public_path('qrpdf/'.$fileName));
        $saveImagePath = public_path($imgName);
        $imagick->writeImages($saveImagePath, true);



        //  $imagick = new Imagick();
  
        // $imagick->readImage(public_path('qrpdf2/test982111.pdf'));
  
        // $saveImagePath = public_path('converted.jpg');
        // $imagick->writeImages($saveImagePath, true);
  

        $swachha_bharat->qrcode=$imgName;
        $swachha_bharat->save();
        
      //return view('qrCode',compact('swachha_id','id','title'));
        
//     $img=url('/').'/'.$imgName;
//     $url_to=url('/surveyform/'.$swachha_id.'/edit');
//     //return   $url_to;

// $image = QrCode::format('png')
//                 ->size(200)->errorCorrection('H')
//                 ->generate($url_to);
// return response($image)->header('Content-type','image/png');
    
    
    return redirect()->route('survey.index')->with('flash_message','Record Added Successfully');
  
      

      
    }


   
    public function edit($id)
    {
        $survey_data=Swachha_Bharat::find($id);
        $ward_data = Ward::orderBy('id','asc')->pluck('ward', 'id');
        return view('admin_master/edit',compact('survey_data','ward_data'));
    }

    public function download($id)
    {
        $survey_data=Swachha_Bharat::find($id);
        $swachha_id=$survey_data->swachha_id;
        $title=$survey_data->title;
        
        $pdf = PDF::loadView('qrCode', compact('swachha_id','title'));
        $path = public_path('qrpdf2/');
        $fileName = $title.$swachha_id.'.pdf' ;
        $pdf->save($path . '/' . $fileName);
       return $pdf->download($title.$swachha_id.'.pdf');
     // return view('qrCode',compact('swachha_id','title'));
    }

   
    public function update(Request $request, $id)
    {
         $this->validate($request, [
           'category' => 'required',
           'Type' => 'required',
           'swachha_id' => 'required',
           'ward' => 'required',
           'title' => 'required',
           'address' => 'required',

            
        ],[
           'category.required' => 'Category is required',
           'Type.required' => 'Type is required',
           'swachha_id.required' => 'Swachh Id is required',
           'ward.required' => 'Ward is required',
           'title.required' => 'Title is required',
           'address.required' => 'Address is required',
          ]);
        $swachha_bharat = Swachha_Bharat::find($id);
        $swachha_bharat = $swachha_bharat->update($request->all());
        return redirect()->route('survey.index')->with('flash_message', 'Record Updated Successfully');
    }

   
    public function destroy($id)
    {
        $swachha_bharat = Swachha_Bharat::find($id)->delete();
        return redirect()->route('survey.index')->with('flash_message','Record Deleted Successfully');
    }
    
    public function downloadExcelFile($type){
        //$survey_data=Swachha_Bharat::all();
        $survey_data = Swachha_Bharat::get()->toArray();
        return \Excel::create('expertphp_demo', function($excel) use ($survey_data) {
            $excel->sheet('sheet name', function($sheet) use ($survey_data)
            {
                $sheet->fromArray($survey_data);
            });
        })->download($type);
    }  


    public function convertImgPdf()
    {
       // echo public_path('qrpdf2/test982111.pdf');exit();
        $imagick = new Imagick();
  
        $imagick->readImage(public_path('qrpdf2/test982111.pdf'));
  
        $saveImagePath = public_path('converted.jpg');
        $imagick->writeImages($saveImagePath, true);
  
        return response()->file($saveImagePath);
    }
}
