<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Swm;
class SwmController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
     public function __construct()
    {
        $this->middleware('auth');
    }
    public function index()
    {
        $swm_data=Swm::orderBy('UID','desc')->get();;
            // return $survey_data;
        return view('swm_master/swm_grid',compact('swm_data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         return view("swm_master/add");
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $this->validate($request, [
            'Category_Name' => 'required',
            'Catgory_Initial' => 'required',
            'Fine_Amount'=>'required',
             
        ],[
            'Category_Name.required' => 'Category Name is required',
            'Catgory_Initial.required' => 'Category Initial is required',
            'Fine_Amount.required' => 'Fine Amount is required ',
            
        ]);
        //return $request->all();
        $swm = new Swm();
        $swm = $swm->Create($request->all());
        return redirect()->route('swm.index')->with('flash_message', 'Record Added Successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $swm=Swm::where('UID',$id)->first();
        //return $swm;
        return view('swm_master/edit',compact('swm'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $this->validate($request, [
            'Category_Name' => 'required',
            'Catgory_Initial' => 'required',
            'Fine_Amount'=>'required',
             
        ],[
            'Category_Name.required' => 'Category Name is required',
            'Catgory_Initial.required' => 'Category Initial is required',
            'Fine_Amount.required' => 'Fine Amount is required ',
            
        ]);
        //return $request->all();
        $swm=Swm::where('UID',$id)->first();

        $swm = $swm->update($request->all());
        return redirect()->route('swm.index')->with('flash_message', 'Record Updated Successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request,$id)
    {
       $swm=Swm::where('UID',$id)->first();
       $swm->Deleted_By = $request->Deleted_By;
       $swm->save();
       $swm->delete();
  
       return redirect()->route('swm.index')->with('flash_message', 'Record Deleted Successfully');
    }
}
