<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use App\Ward;
use App\Fine_Trans_Challan;

class SwmReportController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
     public function index()
    {
    	$ward_data = Ward::orderBy('id','asc')->pluck('ward', 'id');
        return view("swm_report/swm_report",compact('ward_data'));
    }

    public function displayReport(Request $req)
    {
      DB::enableQueryLog();
      $ward= $req->ward;
      $Inserted_Dt= $req->Inserted_Dt;

   
      if($ward=="all")
      {
        $swm_report=DB::select("SELECT fine_trans_challan.UID,fine_trans_challan.Name,fine_trans_challan.Contact_No,fine_mst_category.Category_Name,fine_trans_challan.Fine_Amount,mst_ward.ward FROM `fine_trans_challan` LEFT JOIN mst_ward ON fine_trans_challan.ward=mst_ward.id LEFT JOIN fine_mst_category ON fine_trans_challan.Fine_Category=fine_mst_category.UID WHERE Date(fine_trans_challan.Inserted_Dt)='$Inserted_Dt' AND  fine_trans_challan.Deleted_Dt IS NULL");
        
    //   $query = DB::getQueryLog();
    //     $query = end($query);
    //     print_r($query);
      }
  
	  else
	  {
	  	$swm_report=DB::select("SELECT fine_trans_challan.UID,fine_trans_challan.Name,fine_trans_challan.Contact_No,fine_mst_category.Category_Name,fine_trans_challan.Fine_Amount,mst_ward.ward FROM `fine_trans_challan` LEFT JOIN mst_ward ON fine_trans_challan.ward=mst_ward.id LEFT JOIN fine_mst_category ON fine_trans_challan.Fine_Category=fine_mst_category.UID  WHERE fine_trans_challan.ward='$ward' AND Date(fine_trans_challan.Inserted_Dt)='$Inserted_Dt' AND  fine_trans_challan.Deleted_Dt IS NULL");
	  }
    
        $reportData['data']=$swm_report;
        echo json_encode($reportData);
        exit;
    }

    public function displayImage($UID)
    {
    $swm=Fine_Trans_Challan::where('UID',$UID)->first();
    $imgData['data']=$swm;
    echo json_encode($imgData);
    exit;
    }

    public function downloadSwmExcel(Request $req,$type)
    {
        $url="https://coviguard.in/Bncmc_SBA2/uploads/FineProject/";
        
    DB::enableQueryLog();
    $hidden_ward= $req->hidden_ward;
    $hidden_Inserted_Dt= $req->hidden_Inserted_Dt;

    if($hidden_ward=="all")
      {
        $swm_report=DB::select("SELECT fine_trans_challan.UID,fine_trans_challan.Name,fine_trans_challan.Contact_No,fine_mst_category.Category_Name,fine_trans_challan.Fine_Amount,mst_ward.ward,fine_trans_challan.Person_Image,fine_trans_challan.Place_Image FROM `fine_trans_challan` LEFT JOIN mst_ward ON fine_trans_challan.ward=mst_ward.id LEFT JOIN fine_mst_category ON fine_trans_challan.Fine_Category=fine_mst_category.UID  WHERE Date(fine_trans_challan.Inserted_Dt)='$hidden_Inserted_Dt' AND  fine_trans_challan.Deleted_Dt IS NULL");
      }
  
	  else
	  {
	  	$swm_report=DB::select("SELECT fine_trans_challan.UID,fine_trans_challan.Name,fine_trans_challan.Contact_No,fine_mst_category.Category_Name,fine_trans_challan.Fine_Amount,mst_ward.ward,fine_trans_challan.Person_Image,fine_trans_challan.Place_Image FROM `fine_trans_challan` LEFT JOIN mst_ward ON fine_trans_challan.ward=mst_ward.id LEFT JOIN fine_mst_category ON fine_trans_challan.Fine_Category=fine_mst_category.UID  WHERE fine_trans_challan.ward='$hidden_ward' AND Date(fine_trans_challan.Inserted_Dt)='$hidden_Inserted_Dt' AND  fine_trans_challan.Deleted_Dt IS NULL");
	  }
    
      $data = array();
      foreach ($swm_report as $key=> $swm) {
      $data[] = (array)$swm;  
       #or first convert it and then change its properties using 
       #an array syntax, it's up to you
    }
    if(count($data) == 0) 
    {
      return redirect()->back()->with('dataError','Data not available');
    }
 
    foreach($data as $key=> $row) {
    $data_arr[] = array(
     'Sr. No.'=>$key+1,
     'Full Name' => $row['Name'],
     'Contact Number' => $row['Contact_No'],
     'Ward'=> $row['ward'],
     'Date'=>$hidden_Inserted_Dt,
     'Category ' => $row['Category_Name'],
     'Amount' => $row['Fine_Amount'],
     'Person Image'=>$url.$row['Person_Image'],
     'Place Image'=>$url.$row['Place_Image'],
     );
    }
    

     return \Excel::create('Swm_report_'.$hidden_Inserted_Dt, function($excel) use ($data_arr) {
            $excel->sheet('sheet name', function($sheet) use ($data_arr)
            {
                $sheet->setColumnFormat(array(
                  'C' => ' '
                ));
                $sheet->fromArray($data_arr);
            });
        })->download($type);

    }
}
