@extends('adminlayouts.master')
@section('content')
<div class="container">

					    <!-- page-header -->
						<div class="page-header">
							<h4 class="page-title"> Survey Master</h4>
							<ol class="breadcrumb"><!-- breadcrumb -->
								<li class="breadcrumb-item"><a href="{{url('/dashboard/')}}">Dashboard</a></li>
								<li class="breadcrumb-item"><a href="{{url('/survey/')}}">Survey Master Grid </a></li>
								<li class="breadcrumb-item active" aria-current="page">Edit Survey</li>
							</ol><!-- breadcrumb end -->
						</div>
						<!-- page-header end -->

						 <!--row open-->
						 <?php ?>
						<div class="row">
							<div class="col-lg-12 ">
								<form action="{{route('survey.update',$survey_data->id )}}" method="post">
									{{ csrf_field() }}
									@if (!empty($survey_data->id) | 1==1)
						                <input type="hidden" name="_method" value="PATCH">
						            @endif
             					    <input type="hidden" id="id" name="id" value="{{ $survey_data['id'] or ''}}" >
             					        @if(Auth::check()) 
										<input type="hidden" class="form-control" name="Modified_BY" value="{{$userId = Auth::id()}}">
										@endif
								<div class="card">
									<div class="card-header">
										<h3 class="mb-0 card-title">Edit Survey</h3>
									</div>
									<div class="card-body">
                                        <div class="row">
                                        <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Swachh Id</label>
											<input type="text" class="form-control" name="swachha_id" placeholder="Id" value="{{$survey_data->swachha_id}}" readonly="">
											@if ($errors->has('swachha_id'))
									                <span class="err">
									                    <strong>{{ $errors->first('swachha_id') }}.</strong>
									                </span>
									        @endif

										</div>
									    </div>
                                       
                                        <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Category</label>
											<select class="form-control select2 w-100" name="category">
												<option value=" ">Select Category </option>
												<option value="1" {{$survey_data->category == '1' ? 'selected' : ''}}>Public Toilet</option>
										        <option value="2" {{$survey_data->category == '2' ? 'selected' : ''}}>Community Toilet</option>
												<option value="3" {{$survey_data->category == '3' ? 'selected' : ''}}>Government Hospital</option>
												<option value="4" {{$survey_data->category == '4' ? 'selected' : ''}}>Petrol Pump </option>
												<option value="5" {{$survey_data->category == '5' ? 'selected' : ''}}>Sulabh Toilet </option>
											</select>
											@if ($errors->has('category'))
									                <span class="err">
									                    <strong>{{ $errors->first('category') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
                                            <label class="form-label">Type</label>
											<select class="form-control select2 w-100" name="Type" >
											    <option value="">Select Type</option>
												<option value="Toilet and Urinal" {{$survey_data->Type == 'Toilet and Urinal' ? 'selected' : ''}}>Toilet and Urinal</option>
												<option value="Toilet" {{$survey_data->Type == 'Toilet' ? 'selected' : ''}}>Toilet</option>
											</select>
											@if ($errors->has('Type'))
									                <span class="err">
									                    <strong>{{ $errors->first('Type') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">

											<label class="form-label">Ward </label>
											<select class="form-control select2 w-100" name="ward" >
												<option value=" ">Select Ward </option>
												@foreach($ward_data as $key=> $ward)
													<option value="{{$key}}"  {{$survey_data->ward == $key  ? 'selected' : ''}}>{{$ward}}</option>
												@endforeach
												
											</select>
											@if ($errors->has('ward'))
									                <span class="err">
									                    <strong>{{ $errors->first('ward') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Title</label>
											<input type="text" class="form-control" name="title" placeholder="Title" value="{{$survey_data->title}}">
											@if ($errors->has('title'))
									                <span class="err">
									                    <strong>{{ $errors->first('title') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Address</label>
											<input type="text" class="form-control" name="address" placeholder="Address" value="{{$survey_data->address}}">
											@if ($errors->has('address'))
									                <span class="err">
									                    <strong>{{ $errors->first('address') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
                                        </div>
									</div>
									<div class="card-footer text-left">
										<button type="submit" class="btn btn-primary">Save</button>
										&nbsp;
										<a href="{{ url('/survey/') }}" class="btn btn-default">Cancel</a>
									</div>
								</div>
								</form>

							</div>
						</div>
</div>

@endsection
@section('scripts')
<script>
        $(document).ready(function(){
         var msg = '{{Session::get('serverError')}}';
            var exist = '{{Session::has('serverError')}}';
            if(exist){
	          swal({
				title: msg,
			    type: "error",
				showCancelButton: true,
			
			},
			function(){ 
              location.reload();
           });
           }
        });
</script>
@endsection