@extends('adminlayouts.master')
@section('content')
<div class="container">

						<!-- page-header -->
						<div class="page-header">
							<h4 class="page-title">Advertisement Hoarding Master</h4>
							<ol class="breadcrumb"><!-- breadcrumb -->
								<li class="breadcrumb-item"><a href="{{url('/dashboard/')}}">Dashboard</a></li>
							   <li class="breadcrumb-item active" aria-current="page">Advertisement Hoarding Master </li>
							</ol><!-- breadcrumb end -->
						</div>
						<!-- page-header end -->
                        
                        
                        
						<!-- row -->
						<div class="row">
							<div class="col-md-12 col-lg-12">
								 @if(Session::has('flash_message'))
							      <div class="alert alert-success">
							      {{ Session::get('flash_message') }}
							        </div>
							        @endif
							<div class="card">
								<div class="card-header">
								
									<div class="btn-list text-right">
										<a href="{{ url('/hoarding/create/') }}" class="btn btn-primary"><i class="fa fa-plus" data-toggle="tooltip" title="" data-original-title="fa fa-plus"></i>Add Advertisement Hoarding</a>
									</div>
								</div>
								<div class="card-body">
                                	 <div class="table-responsive">
										<table id="example" class="table table-striped table-bordered">
											<thead>
												<tr>
													<th class="wd-15p">Id</th>
													<th style="width: 10px !important">Swachh Id</th>
												    <th class="wd-15p">Category </th>
												    <th class="wd-15p">Type </th>
												    <th class="wd-15p">Ward </th>
												    <th style="width: 100px !important">Title </th>
												    <th class="wd-15p">Action</th>
													<th class="wd-15p"> Download Pdf</th>
												</tr>
											</thead>

											<tbody>
												@foreach($survey_data as $key => $survey)
												<tr>
													<td>{{($key+1)}}</td>
													<td>{{($survey->swachha_id)}}</td>
													<td>
														@if($survey->category == '1')
														Public Toilet
														@elseif($survey->category == '2')
														Community Toilet
														@elseif($survey->category == '3')
														Government Hospital
														@elseif($survey->category == '4')
														Petrol Pump
														@elseif($survey->category == '5')
														Sulabh Toilet
														@endif

													</td>
													<td>{{$survey->Type}}</td>
													<td>{{$survey->ward}}</td>
													<td data-col-width="20">{{$survey->title}}</td>
												    <td><a href="{{route('survey.edit',$survey->id )}}" class="btn btn-square btn-primary   mb-1"><i class="fa fa-edit" > </i></a>
													<form action="{{route('survey.destroy',$survey->id)}}" method="post" style="display: inline-block;">
														 {!! method_field('delete') !!}
                                                         {!! csrf_field() !!}
							                            <button class="btn btn-square btn-danger  mb-1" type="submit"><i class="fa fa-trash" ></i></button>
													   
												    </form>
												    </td>
												    <td><a href="pdf/{{$survey->id}}" class="btn btn-square btn-primary   mb-1">Download PDF</a></td>
													
												</tr>
												@endforeach
												
											
											</tbody>
										</table>
									</div>
                                </div>
								<!-- table-wrapper -->
							</div>
							<!-- section-wrapper -->
							</div>
						</div>
						</div>

@endsection
@section('scripts')
<script>
        $(document).ready(function(){
         var msg = '{{Session::get('serverError')}}';
            var exist = '{{Session::has('serverError')}}';
            if(exist){
	          swal({
				title: msg,
			    type: "error",
				showCancelButton: true,
			
			},
			function(){ 
              location.reload();
           });
           }
        });
</script>
@endsection