@extends('adminlayouts.master')
@section('content')
<div class="container">

					    <!-- page-header -->
						<div class="page-header">
							<h4 class="page-title">Advertisement Hoarding Master</h4>
							<ol class="breadcrumb"><!-- breadcrumb -->
								<li class="breadcrumb-item"><a href="{{url('/dashboard/')}}">Dashboard</a></li>
								<li class="breadcrumb-item"><a href="{{url('/adv_hoarding/')}}">Advertisement Hoarding Grid </a></li>
								<li class="breadcrumb-item active" aria-current="page"> Add Advertisement Hoarding</li>
							</ol><!-- breadcrumb end -->
						</div>
						<!-- page-header end -->

						 <!--row open-->
						 <?php ?>
						 
						<div class="row">
							<div class="col-lg-12 ">
								<form action="{{route('adv_hoarding.update',$ad->id )}}" method="post">
									{{ csrf_field() }}
									@if (!empty($ad->id) | 1==1)
						                <input type="hidden" name="_method" value="PATCH">
						            @endif
									@if(Auth::check()) 
										<input type="hidden" class="form-control" name="Inserted_BY" value="{{$userId = Auth::id()}}">
										@endif
								   <div class="card">
									<div class="card-header">
										<h3 class="mb-0 card-title">Add Advertisement Hoarding</h3>
									</div>
									<div class="card-body">
                                        <div class="row">
                                        <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">परवाना क्रमांक /  License Number<span style="color:red">*</span></label>
												<input class="form-control" id="licence_no" name="licence_no" rows="1" placeholder="परवाना क्रमांक /  License Number" value="{{$ad->licence_no}}"  readonly>
											@if ($errors->has('licence_no'))
									                <span class="err">
									                    <strong>{{ $errors->first('licence_no') }}.</strong>
									                </span>
									        @endif

										</div>
									    </div>
                                        <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">जाहिरातदाराचे नाव व पत्ता / Advertiser's Name & Address<span style="color:red">*</span></label>
												<textarea class="form-control" id="advertiser_name" name="advertiser_name" rows="1" placeholder="जाहिरातदाराचे नाव व पत्ता / Advertiser's Name & Address">{{$ad->advertiser_name}}</textarea>
											@if ($errors->has('advertiser_name'))
									                <span class="err">
									                    <strong>{{ $errors->first('advertiser_name') }}.</strong>
									                </span>
									        @endif

										</div>
									    </div>
                                       
                                        <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">जाहिरातीचे ठिकाण / Advertisement Location<span style="color:red">*</span></label>
										<textarea class="form-control" id="adv_loc" name="adv_loc" rows="1" placeholder="जाहिरातीचे ठिकाण / Advertisement Location">{{$ad->adv_loc}}</textarea>
											@if ($errors->has('adv_loc'))
									                <span class="err">
									                    <strong>{{ $errors->first('adv_loc') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
                                            <label class="form-label">जाहिरात प्रकार / Advertisement Type<span style="color:red"></span>*</label>
											<select class="form-control select2 w-100" name="adv_type" id="adv_type">
											    <option value="">Select जाहिरात प्रकार / Advertisement Type</option>
												<option value="1" @if($ad->adv_type == '1') selected @endif >प्रकाशित</option>
												<option value="2" @if($ad->adv_type == '2') selected @endif >अप्रकाशित</option>
											</select>
											@if ($errors->has('adv_type'))
									                <span class="err">
									                    <strong>{{ $errors->first('adv_type') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
                                            <label class="form-label">जाहिरात साईज / Advertisement Size</label>
											<input type="text" class="form-control" name="adv_size" placeholder="जाहिरात साईज / Advertisement Size"  value="{{$ad->adv_size}}">
											@if ($errors->has('adv_size'))
									                <span class="err">
									                    <strong>{{ $errors->first('adv_size') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label"> एकूण क्षेत्रफळ / Total Area  <span style="color:red">*</span></label>
											<input type="text" class="form-control" name="total_area" placeholder="एकूण क्षेत्रफळ / Total Area" value="{{$ad->total_area}}">
											@if ($errors->has('total_area'))
									                <span class="err">
									                    <strong>{{ $errors->first('total_area') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									 <!--   <div class="col-md-6">-->
										<!--<div class="form-group">-->
										<!--	<label class="form-label">नूतनीकरण कालावधी / Renewal Period <span style="color:red">*</span></label>-->
										<!--	<input type="text" class="form-control" name="renewal_period" placeholder="नूतनीकरण कालावधी / Renewal Period" value="{{$ad->renewal_period}}">-->
										<!--	@if ($errors->has('renewal_period'))-->
									 <!--               <span class="err">-->
									 <!--                   <strong>{{ $errors->first('renewal_period') }}.</strong>-->
									 <!--               </span>-->
									 <!--       @endif-->
										<!--</div>-->
									 <!--   </div>-->
									    
									    
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">नूतनीकरण कालावधी / Renewal Period From Date <span style="color:red">*</span></label>
											<input type="text" class="form-control" name="from_date" placeholder="नूतनीकरण कालावधी / Renewal Period" value="{{$fromdate}}">
											
										</div>
									    </div>
									    
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">नूतनीकरण कालावधी / Renewal Period To Date <span style="color:red">*</span></label>
											<input type="text" class="form-control" name="to_date" placeholder="नूतनीकरण कालावधी / Renewal Period" value="{{$todate}}">
										
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">अक्षांश / Latitude <span style="color:red">*</span></label>
											<input type="text" class="form-control" name="latitude" placeholder="अक्षांश / Latitude" value="{{$latitude}}" readonly>
											@if ($errors->has('latitude'))
									                <span class="err">
									                    <strong>{{ $errors->first('latitude') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">रेखांश / Longitude <span style="color:red">*</span></label>
											<input type="text" class="form-control" name="longitude" placeholder="रेखांश / Longitude" value="{{$longitude}}" readonly>  
											@if ($errors->has('longitude'))
									                <span class="err">
									                    <strong>{{ $errors->first('longitude') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
                                        </div>
									</div>
									<div class="card-footer text-left">
										<button type="submit" class="btn btn-primary">Save</button>
										&nbsp;
										<a href="{{ url('/adv_hoarding/') }}" class="btn btn-default">Cancel</a>
									</div>
								</div>
								</form>

							</div>
						</div>
</div>

@endsection
@section('scripts')
<script>
        $(document).ready(function(){
         var msg = '{{Session::get('serverError')}}';
            var exist = '{{Session::has('serverError')}}';
            if(exist){
	          swal({
				title: msg,
			    type: "error",
				showCancelButton: true,
			
			},
			function(){ 
              location.reload();
           });
           }
        });
</script>
@endsection