@extends('adminlayouts.master')
@section('content')
<div class="container">

						<!-- page-header -->
						<div class="page-header">
							<h4 class="page-title">Assign Location</h4>
							<ol class="breadcrumb"><!-- breadcrumb -->
								<li class="breadcrumb-item"><a href="{{url('/dashboard/')}}">Dashboard</a></li>
							   <li class="breadcrumb-item active" aria-current="page">Assign Location</li>
							</ol><!-- breadcrumb end -->
						</div>
						<!-- page-header end -->
                        
                        
                        
						<!-- row -->
						<div class="row">
							<div class="col-md-12 col-lg-12">
								 @if(Session::has('flash_message'))
							      <div class="alert alert-success">
							      {{ Session::get('flash_message') }}
							        </div>
							        @endif
							<div class="card">
								<div class="card-header">
								
									<div class="btn-list text-right">
										<a href="{{ url('/assign_location/create/') }}" class="btn btn-primary">Assign Location</a>
									</div>
								</div>
								<div class="card-body">
                                	 <div class="table-responsive">
										<table id="example" class="table table-striped table-bordered ">
											<thead>
												<tr>
													<th class="wd-15p">Id</th>
													<th class="wd-15p">Name</th>
												    <th class="wd-15p">User Type </th>
												    <th class="wd-15p">Ward </th>
												    <th class="wd-15p">Action</th>
													
												</tr>
											</thead>

											<tbody>
												@foreach($assign_location_data as $key => $assign_location)
												<tr>
													<td>{{($key+1)}}</td>
													<td>{{($assign_location->Name)}}</td>
													<td>
														@if($assign_location->user_type == '0')
														Location Collection
														@elseif($assign_location->user_type == '1')
														SWM Fine
														@elseif($assign_location->user_type == '3')
														Sanitory Worker Attendance
														@endif
													</td>
												    <td>{{$assign_location->ward}}</td>
													<td><a href="{{route('assign_location.edit',$assign_location->id  )}}" class="btn btn-square btn-primary  mb-1"><i class="fa fa-edit" > </i></a>
													<form action="{{route('assign_location.destroy',$assign_location->id )}}" method="post" style="display: inline-block;">
														 {!! method_field('delete') !!}
                                                         {!! csrf_field() !!}
							                            <button class="btn btn-square btn-danger  mb-1" type="submit"><i class="fa fa-trash" ></i></button>
													   
												    </form>
												    </td>
												    
													
												</tr>
												@endforeach
												
											
											</tbody>
										</table>
									</div>
                                </div>
								<!-- table-wrapper -->
							</div>
							<!-- section-wrapper -->
							</div>
						</div>
						</div>

@endsection
@section('scripts')
<script>
        $(document).ready(function(){
         var msg = '{{Session::get('serverError')}}';
            var exist = '{{Session::has('serverError')}}';
            if(exist){
	          swal({
				title: msg,
			    type: "error",
				showCancelButton: true,
			
			},
			function(){ 
              location.reload();
           });
           }
        });
</script>
@endsection