@extends('adminlayouts.master')
@section('content')
<div class="container">

					    <!-- page-header -->
						<div class="page-header">
							<h4 class="page-title">Assign Location </h4>
							<ol class="breadcrumb"><!-- breadcrumb -->
								<li class="breadcrumb-item"><a href="{{url('/home/')}}">Dashboard</a></li>
								<li class="breadcrumb-item"><a href="{{url('/survey/')}}">Assign Location  </a></li>
								<li class="breadcrumb-item active" aria-current="page">Assign Location </li>
							</ol><!-- breadcrumb end -->
						</div>
						<!-- page-header end -->

						 <!--row open-->
						 <?php ?>
						<div class="row">
							<div class="col-lg-12 ">
								<form action="{{url('/assign/')}}" method="post">
									{{ csrf_field() }}
									@if(Auth::check()) 
										<input type="hidden" class="form-control" name="Inserted_BY" value="{{$userId = Auth::id()}}">
										@endif
								   <div class="card">
									<div class="card-header">
										<h3 class="mb-0 card-title">Assign Location </h3>
									</div>
									<div class="card-body">
                                        <div class="row">
                                        <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">User</label>
											<select class="form-control select2 w-100" name="LoginId" id="LoginId">
												<option value=" ">Select User </option>
												@foreach($user_data as $key=> $user)
													<option value="{{$key}}">{{$user}}</option>
												@endforeach
											</select>
											@if ($errors->has('LoginId'))
									                <span class="err">
									                    <strong>{{ $errors->first('LoginId') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
                                            <label class="form-label">User Type</label>
                                            <input type="hidden" class="form-control" name="user_type" placeholder="User Type" value="" id="user_type">
											<input type="text" class="form-control" name="user_type_id" placeholder="User Type" value="" id="user_type_id" readonly="">
											@if ($errors->has('user_type'))
									                <span class="err">
									                    <strong>{{ $errors->first('user_type') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
                                            <label class="form-label">Ward</label>
											<select class="form-control select2 w-100" name="ward" >
											    <option value="">Select Ward </option>
												@foreach($ward_data as $key=> $ward)
													<option value="{{$key}}">{{$ward}}</option>
												@endforeach
											</select>
											@if ($errors->has('ward'))
									                <span class="err">
									                    <strong>{{ $errors->first('ward') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
                                            <label class="form-label">Type</label>
											<select class="form-control select2 w-100" name="type" id="type" >
											    <option value="">Select Type</option>
												<option value="SWM Fine">SWM Fine</option>
												<option value="Attendance">Attendance</option>
											</select>
											@if ($errors->has('type'))
									                <span class="err">
									                    <strong>{{ $errors->first('type') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    
									    <div class="col-md-6" style="display: none;" id="total_emp">
										<div class="form-group">
											<label class="form-label">Enter Total Employee</label>
											<input type="text" class="form-control" name="total_emp" placeholder="Enter Total Employee" value="">
											
										</div>
									    </div>
									    

                                        </div>
									</div>
									<div class="card-footer text-left">
										<button type="submit" class="btn btn-primary">Save</button>
										&nbsp;
										<a href="{{ url('/survey/') }}" class="btn btn-default">Cancel</a>
									</div>
								</div>
								</form>

							</div>
						</div>
</div>

@endsection
@section('scripts')
<script>

$('#type').change(function(){ 
    var value = $(this).val();
    if(value=="Attendance")
    {
    $("#total_emp").css("display","block");
    }
});
</script>
<script>
$(document).ready(function(){
 $('#LoginId').change(function(){
  if($(this).val() != '')
  {
   var value = $(this).val();
   $.ajax({
    url:"{{ url('/fetch_user_type/') }}",
    method:"GET",
    dataType: "json",
    data:{LoginId:$(this).val()},
    success:function(result)
    {
     var user_type='';
	if(result==0)
	{
	user_type='Garbage';
   
	}
	else if(result==1)
	{
	user_type='Fine';

	}
	else if(result==2)
	{
	user_type='Toilet';

	}
	else if(result==3)
	{
 
    user_type='Location Mark';
	}
	$("#user_type_id").val(user_type);
	$("#user_type").val(result);
    }

   })
  }
 });
  });
	
</script>
@endsection