@extends('adminlayouts.master')
@section('content')
<div class="container">

					    <!-- page-header -->
						<div class="page-header">
							<h4 class="page-title">Edit User</h4>
							<ol class="breadcrumb"><!-- breadcrumb -->
								<li class="breadcrumb-item"><a href="{{url('/dashboard/')}}">Dashboard</a></li>
								<li class="breadcrumb-item"><a href="{{url('/tbl_collection/')}}">User Registration </a></li>
								<li class="breadcrumb-item active" aria-current="page"> Edit User</li>
							</ol><!-- breadcrumb end -->
						</div>
						<!-- page-header end -->

						<div class="row">
							<div class="col-lg-12 ">
								<form action="{{route('tbl_collection.update',$tble_collection_login->LoginId)}}" method="post">
									{{ csrf_field() }}
									@if (!empty($survey_data->id) | 1==1)
						                <input type="hidden" name="_method" value="PATCH">
						            @endif
						            <input type="hidden" id="LoginId" name="LoginId" value="{{ $tble_collection_login['LoginId '] or ''}}" >
									
								   <div class="card">
									<div class="card-header">
										<h3 class="mb-0 card-title">Edit User </h3>
									</div>
									<div class="card-body">
                                        <div class="row">
                                        <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Name</label>
											<input type="text" class="form-control" name="Name" placeholder="Name" value="{{$tble_collection_login->Name}}">
											@if ($errors->has('Name'))
									                <span class="err">
									                    <strong>{{ $errors->first('Name') }}.</strong>
									                </span>
									        @endif

										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Mobile No.</label>
											<input type="number" class="form-control" name="Mobile_no" placeholder="Mobile No" value="{{$tble_collection_login->Mobile_no}}" id="Mobile_no">
											@if ($errors->has('Mobile_no'))
									                <span class="err">
									                    <strong>{{ $errors->first('Mobile_no') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
                                        <div class="col-md-6">
										<div class="form-group">
                                            <label class="form-label">Gender</label>
                                            <div class="custom-controls-stacked">
											<label class="custom-control custom-radio">
												<input type="radio" class="custom-control-input" name="gender" value="Male" {{$tble_collection_login->gender == 'Male' ? 'checked' : ''}} >
												<span class="custom-control-label">Male</span>
											</label>
											<label class="custom-control custom-radio">
												<input type="radio" class="custom-control-input" name="gender" value="Female" {{$tble_collection_login->gender == 'Female' ? 'checked' : ''}}>
												<span class="custom-control-label">Female</span>
											</label>
										</div>
											@if ($errors->has('gender'))
									                <span class="err">
									                    <strong>{{ $errors->first('gender') }}.</strong>
									                </span>
									        @endif
											
										</div>
									
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
                                            <label class="form-label">User Type</label>
											<select class="form-control select2 w-100" name="User_Type" >
											    <option value="">Select User Type</option>
											    <option value="0" {{$tble_collection_login->User_Type == '0' ? 'selected' : ''}}>Location Collection </option>
												<option value="1" {{$tble_collection_login->User_Type == '1' ? 'selected' : ''}}>SWM Fine</option>
											    <option value="3" {{$tble_collection_login->User_Type == '3' ? 'selected' : ''}}>Sanitory Worker Attendance</option>
											</select>
											@if ($errors->has('User_Type'))
									                <span class="err">
									                    <strong>{{ $errors->first('User_Type') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Username </label>
											<input type="text" class="form-control" name="Username" placeholder="Username" value="{{$tble_collection_login->Username}}" readonly id="Username">
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Password</label>
											<input type="text" class="form-control" name="Password" placeholder="Password" value="{{$tble_collection_login->Password}}">
											@if ($errors->has('Password'))
									                <span class="err">
									                    <strong>{{ $errors->first('Password') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									   
                                        </div>
									</div>
									<div class="card-footer text-left">
										<button type="submit" class="btn btn-primary">Save</button>
										&nbsp;
										<a href="{{ url('/tbl_collection/') }}" class="btn btn-default">Cancel</a>
									</div>
								</div>
								</form>

							</div>
						</div>
</div>

@endsection
@section('scripts')
<script>
$(document).ready(function(){
  $("#Mobile_no").blur(function(){
    $("#Username").val($("#Mobile_no").val());
  });
});
</script>
<script>
        $(document).ready(function(){
         var msg = '{{Session::get('serverError')}}';
            var exist = '{{Session::has('serverError')}}';
            if(exist){
	          swal({
				title: msg,
			    type: "error",
				showCancelButton: true,
			
			},
			function(){ 
              location.reload();
           });
           }
        });
</script>
@endsection