@extends('adminlayouts.master')
@section('content')
<div class="container">

						<!-- page-header -->
						<div class="page-header">
							<h4 class="page-title">User Registration</h4>
							<ol class="breadcrumb"><!-- breadcrumb -->
								<li class="breadcrumb-item"><a href="{{url('/dashboard/')}}">Dashboard</a></li>
							   <li class="breadcrumb-item active" aria-current="page">User Registration</li>
							</ol><!-- breadcrumb end -->
						</div>
						<!-- page-header end -->
                        
                        
                        
						<!-- row -->
						<div class="row">
							<div class="col-md-12 col-lg-12">
								 @if(Session::has('flash_message'))
							      <div class="alert alert-success">
							      {{ Session::get('flash_message') }}
							        </div>
							        @endif
							<div class="card">
								<div class="card-header">
								
									<div class="btn-list text-right">
										<a href="{{ url('/tbl_collection/create/') }}" class="btn btn-primary"><i class="fa fa-plus" data-toggle="tooltip" title="" data-original-title="fa fa-plus"></i>Add User</a>
									</div>
								</div>
								<div class="card-body">
                                	 <div class="table-responsive">
										<table id="example" class="table table-striped table-bordered ">
											<thead>
												<tr>
													<th class="wd-15p">Id</th>
													<th class="wd-15p">Name</th>
											        <th class="wd-15p">Username</th>
												    <th class="wd-15p">User Type </th>
												    <th class="wd-15p">Action</th>
													
												</tr>
											</thead>

											<tbody>
												@foreach($tbl_collection_data as $key => $tbl_collection)
												<tr>
													<td>{{($key+1)}}</td>
													<td>{{($tbl_collection->Name)}}</td>
													<td>{{$tbl_collection->Username}}</td>
													<td>
													    @if($tbl_collection->User_Type == '0')
														Location Collection  
														@elseif($tbl_collection->User_Type == '1')
														SWM Fine 
													    @elseif($tbl_collection->User_Type == '3')
														Sanitory Worker Attendance
														@endif
													</td>
												
													<td><a href="{{route('tbl_collection.edit',$tbl_collection->LoginId )}}" class="btn btn-square btn-primary  mb-1"><i class="fa fa-edit" > </i></a>
													<form action="{{route('tbl_collection.destroy',$tbl_collection->LoginId)}}" method="post" style="display: inline-block;">
														 {!! method_field('delete') !!}
                                                         {!! csrf_field() !!}
							                            <button class="btn btn-square btn-danger  mb-1" type="submit"><i class="fa fa-trash" ></i></button>
													   
												    </form>
												    </td>
												    
													
												</tr>
												@endforeach
												
											
											</tbody>
										</table>
									</div>
                                </div>
								<!-- table-wrapper -->
							</div>
							<!-- section-wrapper -->
							</div>
						</div>
						</div>

@endsection
@section('scripts')
<script>
        $(document).ready(function(){
         var msg = '{{Session::get('serverError')}}';
            var exist = '{{Session::has('serverError')}}';
            if(exist){
	          swal({
				title: msg,
			    type: "error",
				showCancelButton: true,
			
			},
			function(){ 
              location.reload();
           });
           }
        });
</script>
@endsection