@extends('adminlayouts.master')
@section('content')
<div class="container">

					    <!-- page-header -->
						<div class="page-header">
							<h4 class="page-title">User Registration</h4>
							<ol class="breadcrumb"><!-- breadcrumb -->
								<li class="breadcrumb-item"><a href="{{url('/dashboard/')}}">Dashboard</a></li>
								<li class="breadcrumb-item"><a href="{{url('/tbl_collection/')}}">User Registration </a></li>
								<li class="breadcrumb-item active" aria-current="page"> Add User</li>
							</ol><!-- breadcrumb end -->
						</div>
						<!-- page-header end -->

						<div class="row">
							<div class="col-lg-12 ">
								<form action="{{url('/tbl_collection/')}}" method="post">
									{{ csrf_field() }}
									
								   <div class="card">
									<div class="card-header">
										<h3 class="mb-0 card-title">Add User </h3>
									</div>
									<div class="card-body">
                                        <div class="row">
                                        <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Name</label>
											<input type="text" class="form-control" name="Name" placeholder="Name" value="{{ old('Name') }}">
											@if ($errors->has('Name'))
									                <span class="err">
									                    <strong>{{ $errors->first('Name') }}.</strong>
									                </span>
									        @endif

										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Mobile No.</label>
											<input type="number" class="form-control" name="Mobile_no" placeholder="Mobile No" value="{{ old('Mobile_no') }}" id="Mobile_no">
											@if ($errors->has('Mobile_no'))
									                <span class="err">
									                    <strong>{{ $errors->first('Mobile_no') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
                                        <div class="col-md-6">
										<div class="form-group">
                                            <label class="form-label">Gender</label>
                                            <div class="custom-controls-stacked">
											<label class="custom-control custom-radio">
												<input type="radio" class="custom-control-input" name="gender" value="Male"  {{old('gender') == 'Male' ? 'checked' : ''}}>
												<span class="custom-control-label">Male</span>
											</label>
											<label class="custom-control custom-radio">
												<input type="radio" class="custom-control-input" name="gender" value="Female" {{old('gender') == 'Female' ? 'checked' : ''}}>
												<span class="custom-control-label">Female</span>
											</label>
										</div>
											@if ($errors->has('gender'))
									                <span class="err">
									                    <strong>{{ $errors->first('gender') }}.</strong>
									                </span>
									        @endif
											
										</div>
									
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
                                            <label class="form-label">User Type</label>
											<select class="form-control select2 w-100" name="User_Type" >
											    <option value="">Select User Type</option>
											    <option value="0" {{old('User_Type') == '0' ? 'selected' : ''}}>Location Collection </option>
												<option value="1" {{old('User_Type') == '1' ? 'selected' : ''}}>SWM Fine</option>
												<option value="3" {{old('User_Type')== '3' ? 'selected' : ''}}>Sanitory Worker Attendance</option>
											</select>
											@if ($errors->has('User_Type'))
									                <span class="err">
									                    <strong>{{ $errors->first('User_Type') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Username </label>
											<input type="text" class="form-control" name="Username" placeholder="Username" value="{{old('gender') == 'Male' ? 'checked' : ''}}" readonly id="Username">
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Password</label>
											<input type="text" class="form-control" name="Password" placeholder="Password" value="123456">
											@if ($errors->has('Password'))
									                <span class="err">
									                    <strong>{{ $errors->first('Password') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									   
                                        </div>
									</div>
									<div class="card-footer text-left">
										<button type="submit" class="btn btn-primary">Save</button>
										&nbsp;
										<a href="{{ url('/tbl_collection/') }}" class="btn btn-default">Cancel</a>
									</div>
								</div>
								</form>

							</div>
						</div>
</div>

@endsection
@section('scripts')
<script>
$(document).ready(function(){
  $("#Mobile_no").blur(function(){
    $("#Username").val($("#Mobile_no").val());
  });
});
</script>
<script>
        $(document).ready(function(){
         var msg = '{{Session::get('serverError')}}';
            var exist = '{{Session::has('serverError')}}';
            if(exist){
	          swal({
				title: msg,
			    type: "error",
				showCancelButton: true,
			
			},
			function(){ 
              location.reload();
           });
           }
        });
</script>
@endsection