@extends('adminlayouts.master')
@section('content')
<div class="container">

					    <!-- page-header -->
						<div class="page-header">
							<h4 class="page-title">SWM Fine Master</h4>
							<ol class="breadcrumb"><!-- breadcrumb -->
								<li class="breadcrumb-item"><a href="{{url('/dashboard/')}}">Dashboard</a></li>
								<li class="breadcrumb-item"><a href="{{url('/swm/')}}">SWM Fine Grid</a></li>
								<li class="breadcrumb-item active" aria-current="page">Edit SWM Fine</li>
							</ol><!-- breadcrumb end -->
						</div>
						<!-- page-header end -->

						 <!--row open-->
						 <?php ?>
						<div class="row">
							<div class="col-lg-12 ">
								<form action="{{route('swm.update',$swm->UID  )}}" method="post">
									{{ csrf_field() }}
									@if (!empty($swm->UID ) | 1==1)
						                <input type="hidden" name="_method" value="PATCH">
						            @endif
             					
             					        @if(Auth::check()) 
										<input type="hidden" class="form-control" name="Modified_By" value="{{$userId = Auth::id()}}">
										@endif
								<div class="card">
									<div class="card-header">
										<h3 class="mb-0 card-title">Edit SWM Fine</h3>
									</div>
									<div class="card-body">
                                        <div class="row">
                                        <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Category Name</label>
											<input type="text" class="form-control" name="Category_Name" placeholder="Category Name" value="{{$swm->Category_Name}}">
											@if ($errors->has('Category_Name'))
									                <span class="err">
									                    <strong>{{ $errors->first('Category_Name') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
                                            <label class="form-label">Category Initial</label>
											<input type="text" class="form-control" name="Catgory_Initial" placeholder="Category Initial" value="{{$swm->Catgory_Initial}}">
											@if ($errors->has('Catgory_Initial'))
									                <span class="err">
									                    <strong>{{ $errors->first('Catgory_Initial') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									    <div class="col-md-6">
										<div class="form-group">
											<label class="form-label">Fine Amount</label>
											<input type="number" class="form-control" name="Fine_Amount" placeholder="Fine Amount" value="{{$swm->Fine_Amount}}">
											@if ($errors->has('Fine_Amount'))
									                <span class="err">
									                    <strong>{{ $errors->first('Fine_Amount') }}.</strong>
									                </span>
									        @endif
										</div>
									    </div>
									   </div>
									</div>
									<div class="card-footer text-left">
										<button type="submit" class="btn btn-primary">Save</button>
										&nbsp;
										<a href="{{ url('/swm/') }}" class="btn btn-default">Cancel</a>
									</div>
								</div>
								</form>

							</div>
						</div>
</div>

@endsection
@section('scripts')
<script>
        $(document).ready(function(){
         var msg = '{{Session::get('serverError')}}';
            var exist = '{{Session::has('serverError')}}';
            if(exist){
	          swal({
				title: msg,
			    type: "error",
				showCancelButton: true,
			
			},
			function(){ 
              location.reload();
           });
           }
        });
</script>
@endsection