<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});

Route::get('fetch', function () {
    $str='दि. 01/04/2022 ते दि. 31/03/2023';
    preg_match_all('/\d{2}\/\d{2}\/\d{4}/',$str,$matches);
    return $matches[0][0];
});

Route::get('/admin', 'BackEndController@admin');
Route::get('reg', function () {
    return view('auth.register');
});

Route::get('feedaback_report/display_report', 'FeedbackReportController@display_report')->name('feedaback_report/display_report');

Route::get('report2/display_report', 'FeedbackReport2Controller@display_report2');
Route::get('convertImgPdf', 'SwachhaBharatController@convertImgPdf')->name('convertImgPdf');

Route::get('/adv_details/{id}', 'Details@adv_details');

Route::get('/downloadqr/{id}', 'Details@download')->name('download');

// Admin Menu Routes
Route::resource('hoarding','SwachhaBharatController');

Route::resource('adv_hoarding','Adv_Hoarding');




Route::resource('surveyform','SecondFormController');

Route::resource('feedaback_report','FeedbackReportController');
Route::resource('feedaback_report2','FeedbackReport2Controller');





Route::get('color-qr-code', function () {
     return QrCode::size(200)->backgroundColor(255,55,0)->generate('webnersolutions.com');
});

Route::get('/phpinfo', function () {
    return view('phpInfoFile');
});
Auth::routes();



Route::get('/home', 'HomeController@index')->name('home');

Route::get('qr-code-with-image', function () {
 $image = QrCode::format('png')->merge('https://www.w3adda.com/wp-content/uploads/2019/07/laravel.png', 0.3, true)
                ->size(200)->errorCorrection('H')
                ->generate('W3Adda Laravel Tutorial');
return response($image)->header('Content-type','image/png');
});

Route::get('qrcode_blade', function () {
    return view('qrCode');
});

Route::get('/surveyform/{id}', function () {
    return view('admin_master/surveyform');
});

Route::get('google-line-chart', 'HomeController@googleLineChart');

Route::get('version_check', function () {
    return view('admin_master/version');
});

Route::get('/pdf/{id}', 'SwachhaBharatController@download')->name('download');

Route::get('google1', 'HomeController@googleLineChart1');

Route::get('alert', 'SecondFormController@index');


// Send Email for resetting password

Route::get('resetpassword', 'ForgetPasswordController@index')->name('resetpassword');;

Route::post('reset_password','ForgetPasswordController@resetPassword')->name('reset_password');

//Reset Password
Route::get('/forgotpassword/resetpassword/{token}', 'ForgetPasswordController@reset_password');

Route::post('forgotpassword/storenewpassword','ForgetPasswordController@storenewpassword')->name('forgotpassword.storenewpassword');

Route::get('dashboard', 'DashboardController@index');

// Route::get('download-excel-file/{type}', array('as'=>'excel-file','uses'=>'SwachhaBharatController@downloadExcelFile'));



// SWM Master
Route::resource('swm','SwmController');

// Swm Report 
Route::get('swm_report', 'SwmReportController@index')->name('swm_report');
Route::get('display_swm_report', 'SwmReportController@displayReport')->name('display_swm_report');
Route::get('display_image/{UID}', 'SwmReportController@displayImage')->name('display_image');

Route::get('downloadSwmExcel/{type}', array('as'=>'downloadSwmExcel','uses'=>'SwmReportController@downloadSwmExcel'));
Route::get('excel/{type}', array('as'=>'excel','uses'=>'FeedbackReportController@downloadExcelFile'));
// tbl collection login 
Route::get('fetch_user_type', 'LoginCollectionController@fetch_user_type');

Route::resource('tbl_collection','LoginCollectionController');

// Attendance Report 
Route::get('attendance_report', 'AttendanceReportController@index')->name('attendance_report');
Route::get('attendance_report_display', 'AttendanceReportController@displayReport')->name('attendance_report_display');
Route::get('downloadAttendanceExcel/{type}', array('as'=>'downloadAttExcel','uses'=>'AttendanceReportController@downloadAttendanceExcel'));

// Assign Location 

Route::get('fetch_location/{ward_id}', array('as'=>'fetch_location','uses'=>'LoginCollectionController@fetch_location'));
Route::get('fetch_data/{location}', array('as'=>'fetch_data','uses'=>'LoginCollectionController@fetch_data'));
Route::resource('assign_location','AssignLocationController');

// SWm Fine List
Route::get('swm_fine_lst/{mobile_no}', 'SwmFineController@index')->name('swm_fine_lst');


//Clear Config cache:
Route::get('/config-cache', function() {
    $exitCode = Artisan::call('config:cache');
    return '<h1>Clear Config cleared</h1>';
});

//Clear Config Clr:p
Route::get('/config-clr', function() {
    $exitCode = Artisan::call('config:clear');
    return '<h1>Clear Clr cleared</h1>';
});



